package gov.va.med.mhv.vitals.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;


@FacesValidator(value="OxygenValidator")
public class OxygenValidator implements Validator{

	private static final Integer OXYGE_MIN_VALUE = new Integer("1");
	private static final Integer OXYGEN_MAX_VALUE = new Integer("15");
	private static final  String  OXYGEN_DETAIL1="Enter a value less than or equal to 15.";
	private static final  String  OXYGEN_DETAIL2="Enter a value greater than or equal to 1.";
	private static final  String OXYGEN_SUMMARY1 ="The Oxygen Setting value must be less than or equal to 15.";
	private static final  String OXYGEN_SUMMARY2 ="The Oxygen Setting value must be greater than or equal to 1.";

	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
		
		 Integer oxygenValue=(Integer)value;
		 
		 if(oxygenValue != null){
			 if(oxygenValue.compareTo(OXYGEN_MAX_VALUE) > 0){
				 throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, OXYGEN_SUMMARY1, OXYGEN_DETAIL1));
			 }else if(oxygenValue.compareTo(OXYGE_MIN_VALUE) < 0){
				 throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, OXYGEN_SUMMARY2, OXYGEN_DETAIL2));
			 }
		 }
	}
}
